Attribute VB_Name = "MdlMain"
Option Explicit

Declare Sub Sleep Lib "KERNEL32.DLL" (ByVal dwMilliseconds As Long)

'v\CfbNXԍ
Public Const CNT_PASS = 0
Public Const CNT_FAIL = 1
Public Const CNT_TOTAL = 2

'*********
'  
'*********
Private Function Limit_Chk(frq As Double, lvl As Double, lim As FreqLvl_Limit) As Boolean
    
    With lim
        If .intUpFreqChk Then
            If .UpFreq < frq Then Limit_Chk = False: Exit Function
        End If
        If .intLwFreqChk Then
            If .LwFreq > frq Then Limit_Chk = False: Exit Function
        End If
        If .intLwLvlChk Then
            If .LwLevel > lvl Then Limit_Chk = False: Exit Function
        End If
        If .intUpLvlChk Then
            If .UpLevel < lvl Then Limit_Chk = False: Exit Function
        End If
    End With
    
    Limit_Chk = True
End Function

'*****************
'  SWRg`MaxZo
'*****************
Public Sub QryFetcSwrPMax(ByVal msrCh As Long, ByVal sta As Long, ByVal sto As Long, ByRef sngSwr As Double, ByRef SwrF As Double, ByRef SwrP As Long)
    Dim po As Long
    
    sngSwr = BufSwr(sta, msrCh)
    SwrP = sta
    For po = sta To sto
        If sngSwr < BufSwr(po, msrCh) Then
            sngSwr = BufSwr(po, msrCh)
            SwrP = po
        End If
    Next po
    SwrF = BufFrq(SwrP, msrCh)
End Sub

'*****************
'  SWRg`MinZo
'*****************
Public Sub QryFetcSwrPMin(ByVal msrCh As Long, ByVal sta As Long, ByVal sto As Long, ByRef sngSwr As Double, ByRef SwrF As Double, ByRef SwrP As Long)
    Dim po As Long
    Dim swr_min As Single
    
    sngSwr = BufSwr(sta, msrCh)
    SwrP = sta
    For po = sta To sto
        If BufSwr(po, msrCh) < sngSwr Then
            sngSwr = BufSwr(po, msrCh)
            SwrP = po
        End If
    Next po
    SwrF = BufFrq(SwrP, msrCh)
End Sub

'*****************
'  SWRg`Zo
'*****************
Private Sub get_Swr(ByVal msrCh As Long, ByVal sta As Long, ByVal sto As Long)
    Dim po As Long
    Dim swr As Single
    
    For po = sta To sto
        If BufLnm(po, msrCh) = 1 Then
            swr = 10000000000000#   'Error Data
        Else
            swr = Abs((1 + BufLnm(po, msrCh)) / (1 - BufLnm(po, msrCh)))
        End If
        BufSwr(po, msrCh) = swr

        With ChInfo(msrCh).Trace
            If po = 0 Then
                .MinSwr = swr: .MaxSwr = swr
                .MinPSwr = po: .MaxPSwr = po
            Else
                If .MinSwr > swr Then
                    .MinSwr = swr
                    .MinPSwr = po
                End If
                If swr > .MaxSwr Then
                    .MaxSwr = swr
                    .MaxPSwr = po
                End If
            End If
        End With
    Next

End Sub

'*****************
'  CH؂ւ
'*****************
Public Function meas_ch(MeasCh As Long) As Long
    Dim lngErr As Long
    Dim tmp As Long
    
    lngErr = BisPioOut(lngPID, ChInfo(MeasCh).Pio)      'pI/Oo
    If lngACh = MeasCh Then meas_ch = lngErr: Exit Function
    lngACh = MeasCh
    lngErr = BisMeasAct(lngPID, MeasCh + 1)
    lngErr = QrySensFunc(lngPID, tmp)                   'Dummy Meas read
    lngErr = BisSensFunc(lngPID, tmp)
    
    meas_ch = lngErr
End Function


'***********
' Meas\
'***********
Public Sub meas_opt_disp(frm As frmCH, ByVal inpm As Long)
    Dim i As Integer
    
    ' Input Measure
    If 0 < InStr(NA_ProductName, "R3760") Then
        If inpm = McrMeasS21 Then
            frm.lbl_msr.Caption = "S21"
            frm.Option_msr(McrMeasS21).Value = True
        ElseIf inpm = McrMeasS11 Then
            frm.lbl_msr.Caption = "S11"
            frm.Option_msr(McrMeasS11).Value = True
        ElseIf inpm = McrMeasS12 Then
            If lngExpSwBox <> SWBOX_DPDT Then
                frm.lbl_msr.Caption = "S21"
                frm.Option_msr(McrMeasS21).Value = True
            Else
                frm.lbl_msr.Caption = "S12"
                frm.Option_msr(McrMeasS12).Value = True
            End If
        ElseIf inpm = McrMeasS22 Then
            If lngExpSwBox <> SWBOX_DPDT Then
                frm.lbl_msr.Caption = "S11"
                frm.Option_msr(McrMeasS11).Value = True
            Else
                frm.lbl_msr.Caption = "S22"
                frm.Option_msr(McrMeasS22).Value = True
            End If
        End If
        frm.Option_msr(McrMeas__R).Visible = False
    Else
        If inpm = McrMeas_AR Then
            frm.lbl_msr.Caption = "A/R"
            frm.Option_msr(McrMeas_AR).Value = True
        ElseIf inpm = McrMeas__A Then
            frm.lbl_msr.Caption = "A"
            frm.Option_msr(McrMeas__A).Value = True
        Else
            frm.lbl_msr.Caption = "R"
            frm.Option_msr(McrMeas__R).Value = True
        End If
        frm.Option_msr(McrMeas__R).Visible = True
    End If
End Sub

'**********************
' Meas\Rg[
'**********************
Public Sub meas_disp_ctrl(frm As frmCH)
    With frm
        If 0 < InStr(NA_ProductName, "R3760") Then
            .Option_msr(McrMeas_AR).Visible = False
            .Option_msr(McrMeas__A).Visible = False
            .Option_msr(McrMeasS21).Visible = True
            .Option_msr(McrMeasS11).Visible = True
            If lngExpSwBox = SWBOX_DPDT Then
                .Option_msr(McrMeasS12).Visible = True
                .Option_msr(McrMeasS22).Visible = True
            Else
                .Option_msr(McrMeasS12).Visible = False
                .Option_msr(McrMeasS22).Visible = False
            End If
        Else
            .Option_msr(McrMeas_AR).Visible = True
            .Option_msr(McrMeas__A).Visible = True
            .Option_msr(McrMeasS21).Visible = False
            .Option_msr(McrMeasS11).Visible = False
            .Option_msr(McrMeasS12).Visible = False
            .Option_msr(McrMeasS22).Visible = False
        End If
    End With
End Sub

Public Sub FrmWindResize(ByVal ch As Long)
    Dim i As Integer
    Dim ChWndHeight As Variant
    Dim ChWndWidth As Variant
    Dim tmp As Long
    
    If RdCsvInfo.ChNum <= 2 Then
        ChWndHeight = (MDIfrmMain.Height - intfrmCHTopOfst) - 10
        If ch = 0 Then
            ChWndWidth = MDIfrmMain.Width - intfrmCHLeftOfst
        Else
            ChWndWidth = (MDIfrmMain.Width - intfrmCHLeftOfst + 60) / RdCsvInfo.ChNum - 20
        End If
    Else
        ChWndHeight = (MDIfrmMain.Height - intfrmCHTopOfst) / 2 - 10
        If RdCsvInfo.ChNum <= 4 Then
            ChWndWidth = (MDIfrmMain.Width - intfrmCHLeftOfst + 60) / 2 - 20
        ElseIf RdCsvInfo.ChNum = 6 Then
            ChWndWidth = (MDIfrmMain.Width - intfrmCHLeftOfst + 60) / 3 - 15
        Else
            ChWndWidth = (MDIfrmMain.Width - intfrmCHLeftOfst + 60) / 4 - 10
        End If
    End If

    If ChWndHeight < 0 Then Exit Sub
    For i = 0 To ch
        If frm_CH(i).WindowState = 0 Then
            frm_CH(i).Height = ChWndHeight
            frm_CH(i).Width = ChWndWidth
        End If
    Next i

    frm_CH(ch).Top = 0              '*** CH1 ***
    frm_CH(ch).Left = 0

    If RdCsvInfo.ChNum < 3 Then '2CHݒȉ
        If ch = 1 Then frm_CH(ch).Left = ChWndWidth
    ElseIf RdCsvInfo.ChNum < 5 Then '4CHݒȉ
        If ch = 1 Then          '*** CH2 ***
            frm_CH(ch).Left = ChWndWidth
        ElseIf ch = 2 Then      '*** CH3 ***
            frm_CH(ch).Top = ChWndHeight
        ElseIf ch = 3 Then      '*** CH4 ***
            frm_CH(ch).Left = ChWndWidth
            frm_CH(ch).Top = ChWndHeight
        End If
    Else                        '8CHݒȉ
        If RdCsvInfo.ChNum = 6 Then
            tmp = ch
            If 2 < ch Then
                frm_CH(ch).Top = ChWndHeight    '*** CH3 ***
                tmp = ch - 3
            End If
            If ch = 1 Or ch = 4 Then            '*** CH2 or CH5 ***
                frm_CH(ch).Left = ChWndWidth * (tmp And &H3)
            ElseIf ch = 2 Or ch = 5 Then        '*** CH3 or CH7 ***
                frm_CH(ch).Left = ChWndWidth * (tmp And &H3)
            End If
        Else
            If 3 < ch Then
                frm_CH(ch).Top = ChWndHeight    '*** CH5 ***
            End If
            If ch = 1 Or ch = 5 Then            '*** CH2 or CH6 ***
                frm_CH(ch).Left = ChWndWidth * (ch And &H3)
            ElseIf ch = 2 Or ch = 6 Then        '*** CH3 or CH7 ***
                frm_CH(ch).Left = ChWndWidth * (ch And &H3)
            ElseIf ch = 3 Or ch = 7 Then        '*** CH4 or CH8 ***
                frm_CH(ch).Left = ChWndWidth * (ch And &H3)
            End If
        End If
    End If

End Sub

'*****************
' CH tH[
'*****************
Public Function MeasureChAdd(ByVal ini_flg As Integer) As Boolean
    Dim i As Integer
    Dim strCh As String
    
    If ChNum > MAX_CH Then MeasureChAdd = False: Exit Function
    
    '*** New CH Wind Obj  ***
    Set frm_CH(ChNum) = New frmCH
    lngACh = ChNum
    intFrmCh(lngACh) = 1
    strCh = TabCapCh & CStr(lngACh + 1)
    frm_CH(lngACh).SSTab_CH.Caption = strCh & TabCapWev
    frm_CH(lngACh).SSTab_CH.Tab = 1
    frm_CH(lngACh).SSTab_CH.Caption = TabCapSet
    frm_CH(lngACh).SSTab_CH.Tab = 2
    frm_CH(lngACh).SSTab_CH.Caption = TabCapMsr
    frm_CH(lngACh).SSTab_CH.Tab = 3
    frm_CH(lngACh).SSTab_CH.Caption = TabCapLot
    frm_CH(lngACh).SSTab_CH.Tab = 0
    frm_CH(lngACh).Caption = strCh
    For i = 1 To frmCH.Text_stm.UBound
        frm_CH(lngACh).Text_stm(i) = frmCH.Text_stm(i).Text
    Next i
    
    ' ChInfo(lngACh).WaveFrmt ̕ϐ̏L̏Ō˂
    If ini_flg Then frm_CH(lngACh).Check_Format(FmtTypeLogMg).Value = 1
    
    With ChInfo(lngACh)
        .TrLgm = 1024 * lngACh + BIS_TRAC1_LOGMAG
        .TrPhs = 1024 * lngACh + BIS_TRAC1_PHASE
        .TrLnm = 1024 * lngACh + BIS_TRAC1_LINMAG
        .TrRel = 1024 * lngACh + BIS_TRAC1_UDT_RE
        .TrImg = 1024 * lngACh + BIS_TRAC1_UDT_IM
        .TrCa1 = 1024 * lngACh + BIS_TRAC1_CAL1
        .TrCa2 = 1024 * lngACh + BIS_TRAC1_CAL2
        .TrCa3 = 1024 * lngACh + BIS_TRAC1_CAL3
        If ini_flg Then
            With .Trace
                .FmtScale.Mscl.ref = 0: .FmtScale.Mscl.div = 10: .FmtScale.Mscl.pos = 100
                .FmtScale.Pscl.ref = 0: .FmtScale.Pscl.div = 45: .FmtScale.Pscl.pos = 50
                .FmtScale.Dscl.ref = 0: .FmtScale.Dscl.div = 100 * Unit_n: .FmtScale.Dscl.pos = 50
                .FmtScale.SWRscl.ref = 1: .FmtScale.SWRscl.div = 1: .FmtScale.SWRscl.pos = 0
                .FmtScale.Rscl.ref = 0: .FmtScale.Rscl.div = 1: .FmtScale.Rscl.pos = 50
                .FmtScale.Iscl.ref = 0: .FmtScale.Iscl.div = 1: .FmtScale.Iscl.pos = 50
            End With
        End If
    End With
    
    Call FrmWindResize(ChNum)
    frm_CH(ChNum).Show

    ChNum = ChNum + 1   '*** o^CH ***

    MeasureChAdd = True
End Function

'**********************************************************
' Numerical character string + unit -> double data change
'**********************************************************
Public Function dblNumCharStrToDbl(ByRef strDt As String) As Double
    Dim s As String
    Dim d As Double

    s = strDt
    
    If 0 < InStr(s, "m") Then
        d = CDbl(Mid(s, 1, InStr(s, "m") - 1)) * Unit_m
    ElseIf 0 < InStr(s, "u") Then
        d = CDbl(Mid(s, 1, InStr(s, "u") - 1)) * Unit_u
    ElseIf 0 < InStr(s, "n") Then
        d = CDbl(Mid(s, 1, InStr(s, "n") - 1)) * Unit_n
    ElseIf 0 < InStr(s, "p") Then
        d = CDbl(Mid(s, 1, InStr(s, "p") - 1)) * Unit_p
    ElseIf 0 < InStr(s, "f") Then
        d = CDbl(Mid(s, 1, InStr(s, "f") - 1)) * Unit_f
    ElseIf 0 < InStr(s, "H") Then
        d = CDbl(Mid(s, 1, InStr(s, "H") - 1))
    ElseIf 0 < InStr(s, "F") Then
        d = CDbl(Mid(s, 1, InStr(s, "F") - 1))
    Else
        d = CDbl(s)
    End If
    
    dblNumCharStrToDbl = d
End Function


'****************
'   LC 
'****************
Public Function chg_jXLC_value(ByRef dt As Double) As String
    Dim s As String
    Dim d As Single

    s = ""
    d = Math.Abs(dt)
    If d >= Unit_s Then
        s = Format(dt, "#0.000") & " "
    ElseIf d >= Unit_m Then
        d = dt * Multiple_m
        s = Format(d, "#0.000") & " m"
    ElseIf d >= Unit_u Then
        d = dt * Multiple_u
        s = Format(d, "#0.000") & " u"
    ElseIf d >= Unit_n Then
        d = dt * Multiple_n
        s = Format(d, "#0.000") & " n"
    ElseIf d >= Unit_p Then
        d = dt * Multiple_p
        s = Format(d, "#0.000") & " p"
    ElseIf d >= Unit_f Then
        d = dt * Multiple_f
        s = Format(d, "#0.000") & " f"
    End If
    
    chg_jXLC_value = s
End Function

'************************
' g̃xl
'************************
Private Sub MakeDispFreqResult(ByRef MeasTitle As String, ByRef msdt As struct_measdata, strUnitFmt As String)
    With msdt
        .strDispData = Format(MeasTitle & "  " & Format(.ResData1 / Unit_mega, MkrfMHzfkHz$) & " MHz ", "@@@@@@@@@@@@@@")  '"Mx ffff.f "
        .strDispData = .strDispData & Format(Format(.ResData2, strUnitFmt), "@@@@@@@@@@")
    End With
End Sub

'************************
' LC l
'************************
Private Sub MakeDispLC_Result(ByRef MeasTitle As String, ByRef msdt As struct_measdata, ByVal lngjXLC As Long, ByVal x As Double)
    With msdt
        .strDispData = Format(MeasTitle & "  " & Format(.ResData1 / Unit_mega, MkrfMHzfkHz$) & " MHz ", "@@@@@@@@@@@@@@")  '"Mx ffff.f "
        If lngjXLC = 0 Then     ' R
            .strDispData = .strDispData & chg_jXLC_value(x) & "ohm"
        ElseIf lngjXLC = 1 Then ' L
            .strDispData = .strDispData & chg_jXLC_value(x) & "H"
        Else                    ' C
            .strDispData = .strDispData & chg_jXLC_value(x) & "F"
        End If
    End With
End Sub

'************************
' LC l Ȃ
'************************
Private Sub MakeDispLC_NoResult(ByRef MeasTitle As String, ByRef msdt As struct_measdata, ByVal lngjXLC As Long)
    With msdt
        .strDispData = Format(MeasTitle & "  " & Format(.ResData1 / Unit_mega, MkrfMHzfkHz$) & " MHz ", "@@@@@@@@@@@@@@")  '"Mx ffff.f "

        If lngjXLC = 0 Then     ' R
            .strDispData = .strDispData & "****** " & "ohm"
        ElseIf lngjXLC = 1 Then ' L
            .strDispData = .strDispData & "****** " & "H"
        Else                    ' C
            .strDispData = .strDispData & "****** " & "F"
        End If
    End With
End Sub

'****************************
' x|̃xl
'****************************
Private Sub MakeDispLevelResult(ByRef MeasTitle As String, ByRef msdt As struct_measdata, strUnitFmt As String)
    With msdt
        .strDispData = Format(MeasTitle & "  " & Format(.ResData1, StrLvlUnit) & "  ", "@@@@@@@@@@@@@@")  '"Mx llll.l "
        .strDispData = .strDispData & Format(Format(.ResData2, strUnitFmt), "@@@@@@@@@@")
    End With
End Sub

'*********************************************************************
' w背xzf[^T[`Aw背x̃|CgԂ܂B
' ActCh As Long      : CH
' Pnt As Long        : CH̐ݒ|Cg
' sngLvl As Single   : w背xiT[`xj
' LvlBuf() As Single : T[`zf[^
' lmt_chk As Boolean : zf[^jAEf[^̏ꍇ
'                      őAŏ`FbN^Ȃ
'*********************************************************************
Public Function search_level_point(ActCh As Long, Pnt As Long, sngLvl As Double, ByRef LvlBuf() As Double, lmt_chk As Boolean) As Integer
    Dim i As Integer
    Dim NearFreqPoint As Integer
    Dim tmp1 As Double
    Dim tmp2 As Double
    
    If lmt_chk = True Then
        If sngLvl < LvlBuf(0, ActCh) Then
            search_level_point = 0
            Exit Function
        ElseIf LvlBuf(Pnt - 1, ActCh) < sngLvl Then
            search_level_point = Pnt - 1
            Exit Function
        End If
    End If
    
    For i = 0 To Pnt - 2
        If LvlBuf(i, ActCh) <= sngLvl And sngLvl <= LvlBuf(i + 1, ActCh) Then
            tmp1 = sngLvl - LvlBuf(i, ActCh)
            tmp2 = LvlBuf(i + 1, ActCh) - sngLvl
            If tmp1 < tmp2 Then
                search_level_point = i
            Else
                search_level_point = i + 1
            End If
            Exit For
        End If
    Next i
End Function

'***********************************************************************************
'  Function name  Fget_r_reactance
'  Function    FObtains the resistance and reactance values from the real number and imaginary number data.
'  Argument    F Z0 Port Impedance (ohm)
'            real As Double  Real number data
'            imag As Double  Imaginary number data
'            r As Single     A variable to be returned with the obtained resistance value assigned.
'            x As Single     A variable to be returned with the obtained reactance value assigned.
'  Functional descriptionsFObtains the resistence and reactance values from the impedance value set by Z0 on the screen (frmMain).
'  return      :
'              : 1  = L
'              : 2  = C
'***********************************************************************************
Public Function get_r_reactance(ByVal Z0 As Double, ByVal real As Double, ByVal imag As Double, ByRef R As Single, ByRef x As Double, f As Double) As Long
      
    R = ((1 - real ^ 2 - imag ^ 2) / ((1 - real) ^ 2 + imag ^ 2)) * Z0
    x = ((2 * imag) / ((1 - real) ^ 2 + imag ^ 2)) * Z0
    If x < 0 Then
        x = -1# / (2# * pi# * f * x)        'C
        get_r_reactance = McrResult_C
    Else
        x = CDbl(R) * x / (2# * pi# * f)    'L
        get_r_reactance = McrResult_L
    End If
    
End Function

'***********************************************************************************
'  Function name  FGet_X_Y_Interpolation
'  Function    FX Interpolation
'  Argument    FByRef p As Integer     Mesurement point.
'                ByRef x As Double      The output destination of the interpolated frequency point value.
'                ByRef y As Single      The output destination of the interpolated level value.
'                ByRef X_Data() As Double Mesurement frequency(array)
'                ByRef Y_Data() As Single Mesurement data(array)
'  Return value  Fnothing
'  Functional descriptionsFx,y interpolation
'***********************************************************************************
Public Sub Get_X_Y_Interpolation(ByVal lngCh As Long, ByRef p As Long, ByRef x As Double, ByRef y As Double, ByRef X_Data() As Double, ByRef Y_Data() As Single)
    
    If p <> 0 Then
        If X_Data(p - 1, lngCh) < x And x <= X_Data(p, lngCh) Then
            p = p - 1
        ElseIf X_Data(p, lngCh) <= x And x < X_Data(p - 1, lngCh) Then
            p = p - 1
        End If
    End If
    If X_Data(p + 1, lngCh) = X_Data(p, lngCh) Then
        y = Y_Data(p, lngCh) + (Y_Data(p + 1, lngCh) - Y_Data(p, lngCh))
    Else
        y = Y_Data(p, lngCh) + (x - X_Data(p, lngCh)) * ((Y_Data(p + 1, lngCh) - Y_Data(p, lngCh)) / (X_Data(p + 1, lngCh) - X_Data(p, lngCh)))
        x = p + (x - X_Data(p, lngCh)) * ((p + 1) - p) / (X_Data(p + 1, lngCh) - X_Data(p, lngCh))
    End If

End Sub

'****************
' Get LCR l
'****************
Public Sub Get_LCR_Meas_Data(ByVal lngCh As Long, ByVal no As Long, ByRef msi As struct_measInfo, ByRef msdt As struct_measdata, ByRef msfmt As String, _
            ByRef inf_lcr() As struct_resonance, ByVal inf_num As Long, ByRef ch_meas_i() As struct_resonance_meas, ByRef ch_meas_num() As Long)
    Dim i As Long
    Dim ii As Long
    Dim lngjXLC As Long
    Dim R As Single
    Dim x As Double
    Dim dsp_no As Integer

    On Error GoTo ErrGet_LCR_Meas
    
    For i = 0 To inf_num - 1
        For ii = 0 To ch_meas_num(lngCh, i) - 1
            If ch_meas_i(lngCh, i, ii).MeasNo = no Then
                dsp_no = ch_meas_i(lngCh, i, ii).SameMeasNo
                With msi
                    Select Case ch_meas_i(lngCh, i, ii).Type
                        Case McrMeasRESMIN
                            msdt.ResData1 = inf_lcr(lngCh, i).result_F
                            msdt.ResData2 = inf_lcr(lngCh, i).result_lvl
                            msdt.ResType = McrFreq
                            msdt.ResCh = lngCh
                            msdt.ResTrcFmt = WAVE_FORMAT_LOGMAG
                            msdt.DspMkrNo = dsp_no
                            Call MakeDispFreqResult("M" & CStr(dsp_no) & " :", msdt, StrLogUnit)
                        Case McrMeasRESL
                            msdt.ResType = McrFreq
                            msdt.ResCh = lngCh
                            msdt.ResTrcFmt = WAVE_FORMAT__SMITH
                            msdt.ResData1 = inf_lcr(lngCh, i).result_F
                            msdt.freqp1 = inf_lcr(lngCh, i).result_pF
                            msdt.DspMkrNo = dsp_no
                            If inf_lcr(lngCh, i).result_L = -1 Then
                                msdt.ResJudge = JUDG___NO
                                msdt.ResData2 = -1
                                Call MakeDispLC_NoResult("M" & CStr(dsp_no) & " :", msdt, inf_lcr(lngCh, i).result_L)
                            Else
                                msdt.ResData2 = inf_lcr(lngCh, i).result_L
                                Call MakeDispLC_Result("M" & CStr(dsp_no) & " :", msdt, McrResult_L, inf_lcr(lngCh, i).result_L)
                            End If
                       Case McrMeasRESC
                            msdt.ResType = McrFreq
                            msdt.ResCh = lngCh
                            msdt.ResTrcFmt = WAVE_FORMAT__SMITH
                            msdt.ResData1 = inf_lcr(lngCh, i).result_F
                            msdt.freqp1 = inf_lcr(lngCh, i).result_pF
                            msdt.DspMkrNo = dsp_no
                            If inf_lcr(lngCh, i).result_C = -1 Then
                                msdt.ResJudge = JUDG___NO
                                msdt.ResData2 = -1
                                Call MakeDispLC_NoResult("M" & CStr(dsp_no) & " :", msdt, inf_lcr(lngCh, i).result_C)
                            Else
                                msdt.ResData2 = inf_lcr(lngCh, i).result_C
                                Call MakeDispLC_Result("M" & CStr(dsp_no) & " :", msdt, McrResult_C, inf_lcr(lngCh, i).result_C)
                            End If
                        Case McrMeasRESR
                            msdt.ResType = McrFreq
                            msdt.ResCh = lngCh
                            msdt.ResTrcFmt = WAVE_FORMAT__SMITH
                            msdt.ResData1 = inf_lcr(lngCh, i).result_F
                            msdt.ResData2 = inf_lcr(lngCh, i).result_R
                            msdt.freqp1 = inf_lcr(lngCh, i).result_pF
                            msdt.DspMkrNo = dsp_no
                            Call MakeDispLC_Result("M" & CStr(dsp_no) & " :", msdt, McrResult_R, inf_lcr(lngCh, i).result_R)
                    End Select
                End With
            End If
        Next ii
    Next i
    
    
ErrGet_LCR_MeasEnd:
    On Error GoTo 0
    Exit Sub

ErrGet_LCR_Meas:
    msdt.ResData2 = ERR_VALUE
    GoTo ErrGet_LCR_MeasEnd

End Sub

'****************
'   LogMag 
'****************
Public Sub MeasLogmag(ByVal lngCh As Long, ByVal no As Long, ByRef msi As struct_measInfo, ByRef msdt As struct_measdata, ByRef msfmt As String, _
            ByRef inf_lcr() As struct_resonance, ByVal inf_num As Long, ByRef ch_meas_i() As struct_resonance_meas, ByRef ch_meas_num() As Long)
    Dim lngErr As Long
    Dim stf As Double
    Dim spf As Double
    Dim vvv As Double
    Dim fff As Double
    Dim ppp As Long
    Dim f1 As Double
    Dim f2 As Double

    On Error GoTo ErrMeasLogmag
    msdt.ResJudge = JUDG_FAIL
    Call Get_LCR_Meas_Data(lngCh, no, msi, msdt, msfmt, inf_lcr, inf_num, ch_meas_i, ch_meas_num)
    With msi
        Select Case .MeasType
            Case McrMeasMAX
                lngErr = QryFetcMax(lngPID, .TrcNumb, .PStart, .PStop, .MeasResult, msdt.ResData1, msdt.freqp1)
                If BufFrq(.PStart, lngCh) <> .Start Then
                    lngErr = QryFetcCval(lngPID, .TrcNumb, .Start, vvv)
                    If .MeasResult < vvv Then .MeasResult = vvv: msdt.ResData1 = .Start
                End If
                If BufFrq(.PStop, lngCh) <> .Stop Then
                    lngErr = QryFetcCval(lngPID, .TrcNumb, .Stop, fff)
                    If .MeasResult < fff Then .MeasResult = fff: msdt.ResData1 = .Stop
                End If
                msdt.ResData2 = .MeasResult
                msdt.ResType = McrFreq
                msdt.ResCh = lngCh
                msdt.ResTrcFmt = WAVE_FORMAT_LOGMAG
                msdt.DspMkrNo = no
                Call MakeDispFreqResult("M" & CStr(no) & " :", msdt, StrLogUnit)
            Case McrMeasMIN
                lngErr = QryFetcMin(lngPID, .TrcNumb, .PStart, .PStop, .MeasResult, msdt.ResData1, msdt.freqp1)
                If BufFrq(.PStart, lngCh) <> .Start Then
                    lngErr = QryFetcCval(lngPID, .TrcNumb, .Start, vvv)
                    If vvv < .MeasResult Then .MeasResult = vvv: msdt.ResData1 = .Start
                End If
                If BufFrq(.PStop, lngCh) <> .Stop Then
                    lngErr = QryFetcCval(lngPID, .TrcNumb, .Stop, fff)
                    If fff < .MeasResult Then .MeasResult = fff: msdt.ResData1 = .Stop
                End If
                msdt.ResData2 = .MeasResult
                msdt.ResType = McrFreq
                msdt.ResCh = lngCh
                msdt.ResTrcFmt = WAVE_FORMAT_LOGMAG
                msdt.DspMkrNo = no
                Call MakeDispFreqResult("M" & CStr(no) & " :", msdt, StrLogUnit)
            Case McrMeasVAL
                lngErr = QryFetcCval(lngPID, .TrcNumb, .Start, .MeasResult)
                msdt.ResData2 = .MeasResult
                msdt.ResType = McrFreq
                msdt.ResCh = lngCh
                msdt.ResTrcFmt = WAVE_FORMAT_LOGMAG
                msdt.ResData1 = .Start
                msdt.freqp1 = .PStart
                msdt.DspMkrNo = no
                Call MakeDispFreqResult("M" & CStr(no) & " :", msdt, StrLogUnit)
            Case McrMeasPWRVAL
                ppp = search_level_point(lngCh, ChInfo(lngCh).lngTotP, .Start, BufLvl, True)
                If BufLvl(ppp, lngCh) <> .Start Then
                    If ppp <> 0 Then
                        If BufLvl(ppp - 1, lngCh) < .Start And .Start < BufLvl(ppp, lngCh) Then ppp = ppp - 1
                    End If
                    f1 = BufLvl(ppp, lngCh)         'x0
                    f2 = BufLvl(ppp + 1, lngCh)     'x1
                    fff = BufLgm(ppp, lngCh)        'y0
                    vvv = BufLgm(ppp + 1, lngCh)    'y1
                    vvv = fff + (.Start - f1) * (vvv - fff) / (f2 - f1) 'y = y0+(x-x0)*(y1-y0)/(x1-x0)
                    .MeasResult = vvv
                Else
                    .MeasResult = BufLgm(ppp, lngCh)
                End If
                msdt.ResData2 = .MeasResult
                msdt.ResType = McrLevel
                msdt.ResCh = lngCh
                msdt.ResTrcFmt = WAVE_FORMAT_LOGMAG
                msdt.freqp1 = ppp
                msdt.ResData1 = .Start
                msdt.DspMkrNo = no
                Call MakeDispLevelResult("M" & CStr(no) & " :", msdt, StrLvlUnit)
            Case McrMeasPKF0
                lngErr = QryFetcMax(lngPID, .TrcNumb, .PStart, .PStop, .MeasResult, msdt.ResData1, ppp)
                vvv = .MeasResult - .dBDown
                lngErr = QryFetcTarg(lngPID, .TrcNumb, .PStart, ppp, vvv, stf, msdt.freqp1, msdt.freqp2)
                lngErr = QryFetcTarg(lngPID, .TrcNumb, ppp, .PStop, vvv, spf, msdt.freqp1, msdt.freqp2)
                .MeasResult = (spf - stf) / 2 + stf
                lngErr = QryFetcCval(lngPID, .TrcNumb, .MeasResult, vvv)
                msdt.ResData1 = .MeasResult
                msdt.ResData2 = vvv
                msdt.ResType = McrFreq
                msdt.ResCh = lngCh
                msdt.ResTrcFmt = WAVE_FORMAT_LOGMAG
                msdt.DspMkrNo = no
                Call MakeDispFreqResult("M" & CStr(no) & " :", msdt, StrLogUnit)
            Case McrMeasPKLF
                lngErr = QryFetcMax(lngPID, .TrcNumb, .PStart, .PStop, .MeasResult, msdt.ResData1, ppp)
                vvv = .MeasResult - .dBDown
                lngErr = QryFetcTarg(lngPID, .TrcNumb, .PStart, ppp, vvv, .MeasResult, msdt.freqp1, msdt.freqp2)
                msdt.ResData1 = .MeasResult
                msdt.ResData2 = vvv
                msdt.ResType = McrFreq
                msdt.ResCh = lngCh
                msdt.ResTrcFmt = WAVE_FORMAT_LOGMAG
                msdt.DspMkrNo = no
                Call MakeDispFreqResult("M" & CStr(no) & " :", msdt, StrLogUnit)
            Case McrMeasPKHF
                lngErr = QryFetcMax(lngPID, .TrcNumb, .PStart, .PStop, .MeasResult, msdt.ResData1, ppp)
                vvv = .MeasResult - .dBDown
                lngErr = QryFetcTarg(lngPID, .TrcNumb, ppp, .PStop, vvv, .MeasResult, msdt.freqp1, msdt.freqp2)
                msdt.ResData1 = .MeasResult
                msdt.ResData2 = vvv
                msdt.ResType = McrFreq
                msdt.ResCh = lngCh
                msdt.ResTrcFmt = WAVE_FORMAT_LOGMAG
                Call MakeDispFreqResult("M" & CStr(no) & " :", msdt, StrLogUnit)
            Case McrMeasPKBW
                lngErr = QryFetcMax(lngPID, .TrcNumb, .PStart, .PStop, .MeasResult, msdt.ResData1, ppp)
                vvv = .MeasResult - .dBDown
                lngErr = QryFetcTarg(lngPID, .TrcNumb, .PStart, ppp, vvv, stf, msdt.freqp1, msdt.freqp2)
                lngErr = QryFetcTarg(lngPID, .TrcNumb, ppp, .PStop, vvv, spf, msdt.freqp1, msdt.freqp2)
                .MeasResult = (spf - stf) / 2 + stf
                msdt.ResData1 = .MeasResult
                msdt.ResData2 = vvv
                msdt.ResType = McrFreq
                msdt.ResCh = lngCh
                msdt.ResTrcFmt = WAVE_FORMAT_LOGMAG
                msdt.DspMkrNo = no
                Call MakeDispFreqResult("M" & CStr(no) & " :", msdt, StrLogUnit)
            Case McrMeasSPF0

            Case McrMeasSPLF

            Case McrMeasSPHF

            Case McrMeasSPBW

            Case McrMeasRFF0

            Case McrMeasRFLF

            Case McrMeasRFHF

            Case McrMeasRFBW

            Case McrMeasTRGT
                vvv = vvv - .dBDown
                lngErr = QryFetcTarg(lngPID, .TrcNumb, .PStart, .PStop, vvv, .MeasResult, msdt.freqp1, msdt.freqp2)
                msdt.ResData1 = .MeasResult
                msdt.ResData2 = vvv
                msdt.ResType = McrFreq
                msdt.ResCh = lngCh
                msdt.ResTrcFmt = WAVE_FORMAT_LOGMAG
                msdt.DspMkrNo = no
        End Select
    End With

ErrMeasLogmagEnd:
    On Error GoTo 0
    Exit Sub

ErrMeasLogmag:
    msdt.ResData2 = ERR_VALUE
    GoTo ErrMeasLogmagEnd

End Sub


'****************
'   SWR 
'****************
Public Sub MeasSwr(ByVal lngCh As Long, ByVal no As Long, ByRef msi As struct_measInfo, ByRef msdt As struct_measdata, ByRef msfmt As String)
    Dim lngErr As Long
    Dim stf As Double
    Dim spf As Double
    Dim vvv As Double
    Dim fff As Double
    Dim ppp As Long
    Dim f1 As Double
    Dim f2 As Double

    On Error GoTo ErrMeasSwr
    msdt.ResJudge = JUDG_FAIL
    With msi
        Select Case .MeasType
            Case McrMeasMAX
                Call QryFetcSwrPMax(lngCh, .PStart, .PStop, .MeasResult, msdt.ResData1, msdt.freqp1)
                If BufFrq(.PStart, lngCh) <> .Start Then
                    lngErr = QryFetcCval(lngPID, .TrcNumb, .Start, vvv)
                    If vvv = 1 Then
                        vvv = 10000000000000#   'Error Data
                    Else
                        vvv = Abs((1 + vvv) / (1 - vvv))
                    End If
                    If .MeasResult < vvv Then .MeasResult = vvv: msdt.ResData1 = .Start
                End If
                If BufFrq(.PStop, lngCh) <> .Stop Then
                    lngErr = QryFetcCval(lngPID, .TrcNumb, .Stop, fff)
                    If fff = 1 Then
                        fff = 10000000000000#   'Error Data
                    Else
                        fff = Abs((1 + fff) / (1 - fff))
                    End If
                    If .MeasResult < fff Then .MeasResult = fff: msdt.ResData1 = .Stop
                End If
                msdt.ResData2 = .MeasResult
                msdt.ResType = McrFreq
                msdt.ResCh = lngCh
                msdt.ResTrcFmt = WAVE_FORMAT____SWR
                msdt.DspMkrNo = no
               Call MakeDispFreqResult("M" & CStr(no) & " :", msdt, StrSwrUnit)
           Case McrMeasMIN
                Call QryFetcSwrPMin(lngCh, .PStart, .PStop, .MeasResult, msdt.ResData1, msdt.freqp1)
                If BufFrq(.PStart, lngCh) <> .Start Then
                    lngErr = QryFetcCval(lngPID, .TrcNumb, .Start, vvv)
                    If vvv = 1 Then
                        vvv = 10000000000000#   'Error Data
                    Else
                        vvv = Abs((1 + vvv) / (1 - vvv))
                    End If
                    If vvv < .MeasResult Then .MeasResult = vvv: msdt.ResData1 = .Start
                End If
                If BufFrq(.PStop, lngCh) <> .Stop Then
                    lngErr = QryFetcCval(lngPID, .TrcNumb, .Stop, fff)
                    If fff = 1 Then
                        fff = 10000000000000#   'Error Data
                    Else
                        fff = Abs((1 + fff) / (1 - fff))
                    End If
                    If fff < .MeasResult Then .MeasResult = fff: msdt.ResData1 = .Stop
                End If
                msdt.ResData2 = .MeasResult
                msdt.ResType = McrFreq
                msdt.ResCh = lngCh
                msdt.ResTrcFmt = WAVE_FORMAT____SWR
                msdt.DspMkrNo = no
                Call MakeDispFreqResult("M" & CStr(no) & " :", msdt, StrSwrUnit)
            Case McrMeasVAL
                lngErr = QryFetcCval(lngPID, .TrcNumb, .Start, .MeasResult)
                If .MeasResult = 1 Then
                    msdt.ResData2 = 10000000000000#   'Error Data
                Else
                    msdt.ResData2 = Abs((1 + .MeasResult) / (1 - .MeasResult))
                End If
                msdt.ResType = McrFreq
                msdt.ResCh = lngCh
                msdt.ResTrcFmt = WAVE_FORMAT____SWR
                msdt.ResData1 = .Start
                msdt.freqp1 = .PStart
                msdt.DspMkrNo = no
                Call MakeDispFreqResult("M" & CStr(no) & " :", msdt, StrSwrUnit)
        End Select
    End With

ErrMeasSwrEnd:
    On Error GoTo 0
    Exit Sub

ErrMeasSwr:
    msdt.ResData2 = ERR_VALUE
    GoTo ErrMeasSwrEnd

End Sub


'****************
'   Smith 
'****************
Public Sub MeasSmith(ByVal lngCh As Long, ByVal no As Long, ByRef msi As struct_measInfo, ByRef msdt As struct_measdata, ByRef msfmt As String, _
            ByRef inf_lcr() As struct_resonance, ByVal inf_num As Long, ByRef ch_meas_i() As struct_resonance_meas, ByRef ch_meas_num() As Long)
    Dim lngErr As Long
    Dim stf As Double
    Dim lngjXLC As Long
    Dim re As Double
    Dim im As Double
    Dim R As Single
    Dim x As Double

    On Error GoTo ErrMeasSmith
    msdt.ResJudge = JUDG_FAIL
    Call Get_LCR_Meas_Data(lngCh, no, msi, msdt, msfmt, inf_lcr, inf_num, ch_meas_i, ch_meas_num)
    With msi
        Select Case .MeasType
            Case McrMeasVALL
                re = BufReal(.PStart, lngCh)
                im = BufImag(.PStart, lngCh)
                stf = .Start: Call Get_X_Y_Interpolation(lngCh, .PStart, stf, re, BufFrq(), BufReal())
                stf = .Start: Call Get_X_Y_Interpolation(lngCh, .PStart, stf, im, BufFrq(), BufImag())
                lngjXLC = get_r_reactance(ChInfo(lngCh).ImpZ0, re, im, R, x, .Start)
                msdt.ResType = McrFreq
                msdt.ResCh = lngCh
                msdt.ResTrcFmt = WAVE_FORMAT__SMITH
                msdt.ResData1 = .Start
                msdt.freqp1 = .PStart
                msdt.DspMkrNo = no
                If lngjXLC = McrResult_C Then
                    msdt.ResJudge = JUDG___NO
                    msdt.ResData2 = -1
                    Call MakeDispLC_NoResult("M" & CStr(no) & " :", msdt, McrResult_L)
                Else
                    msdt.ResData2 = x
                    Call MakeDispLC_Result("M" & CStr(no) & " :", msdt, McrResult_L, x)
                End If
           Case McrMeasVALC
                re = BufReal(.PStart, lngCh)
                im = BufImag(.PStart, lngCh)
                stf = .Start: Call Get_X_Y_Interpolation(lngCh, .PStart, stf, re, BufFrq(), BufReal())
                stf = .Start: Call Get_X_Y_Interpolation(lngCh, .PStart, stf, im, BufFrq(), BufImag())
                lngjXLC = get_r_reactance(ChInfo(lngCh).ImpZ0, re, im, R, x, .Start)
                msdt.ResType = McrFreq
                msdt.ResCh = lngCh
                msdt.ResTrcFmt = WAVE_FORMAT__SMITH
                msdt.ResData1 = .Start
                msdt.freqp1 = .PStart
                msdt.DspMkrNo = no
                If lngjXLC = McrResult_L Then
                    msdt.ResJudge = JUDG___NO
                    msdt.ResData2 = -1
                    Call MakeDispLC_NoResult("M" & CStr(no) & " :", msdt, McrResult_C)
                Else
                    msdt.ResData2 = x
                    Call MakeDispLC_Result("M" & CStr(no) & " :", msdt, McrResult_C, x)
                End If
            Case McrMeasVALR
                re = BufReal(.PStart, lngCh)
                im = BufImag(.PStart, lngCh)
                stf = .Start: Call Get_X_Y_Interpolation(lngCh, .PStart, stf, re, BufFrq(), BufReal())
                stf = .Start: Call Get_X_Y_Interpolation(lngCh, .PStart, stf, im, BufFrq(), BufImag())
                lngjXLC = get_r_reactance(ChInfo(lngCh).ImpZ0, re, im, R, x, .Start)
                msdt.ResType = McrFreq
                msdt.ResCh = lngCh
                msdt.ResTrcFmt = WAVE_FORMAT__SMITH
                msdt.ResData1 = .Start
                msdt.ResData2 = R
                msdt.freqp1 = .PStart
                msdt.DspMkrNo = no
                Call MakeDispLC_Result("M" & CStr(no) & " :", msdt, McrResult_R, R)
        End Select
    End With
    
ErrMeasSmithEnd:
    On Error GoTo 0
    Exit Sub

ErrMeasSmith:
    msdt.ResData2 = ERR_VALUE
    GoTo ErrMeasSmithEnd

End Sub


'****************
'   LCR 
'****************
Public Sub MeasLCR(ByVal lngCh As Long, ByRef ilcr As struct_resonance)
    Dim lngErr As Long
    Dim TrcNo As Long
    Dim vvv As Double
    Dim fff As Double
    Dim re As Double
    Dim im As Double
    Dim lngjXLC As Long
    Dim R As Single
    Dim x As Double

    On Error GoTo ErrMeasLCR

    With ilcr
    '*** Logmag Min Level search ***
        TrcNo = ChInfo(lngCh).TrLgm
        lngErr = QryFetcMin(lngPID, TrcNo, .p_start, .p_stop, .result_lvl, .result_F, .result_pF)
        If BufFrq(.p_start, lngCh) <> .f_start Then
        lngErr = QryFetcCval(lngPID, TrcNo, .f_start, vvv)
        If vvv < .result_lvl Then .result_lvl = vvv: .result_F = .f_start
        End If
        If BufFrq(.p_stop, lngCh) <> .f_stop Then
        lngErr = QryFetcCval(lngPID, TrcNo, .f_stop, fff)
        If fff < .result_lvl Then .result_lvl = fff: .result_F = .f_stop
        End If
    '*** Get Real/Imag data (Logmag Min Level frequency same)  ***
        TrcNo = ChInfo(lngCh).TrRel
        lngErr = QryFetcCval(lngPID, TrcNo, .result_F, re)
        TrcNo = ChInfo(lngCh).TrImg
        lngErr = QryFetcCval(lngPID, TrcNo, .result_F, im)
        lngjXLC = get_r_reactance(ChInfo(lngCh).ImpZ0, re, im, R, x, .result_F)
        If lngjXLC = McrResult_C Then
            .result_C = x
            .result_L = -1
        Else
            .result_C = -1
            .result_L = x
        End If
        .result_R = R
        
    End With

ErrMeasLCR:
    On Error GoTo 0

End Sub

'****************
'   LCR 
'****************
Public Sub Chk_LCR_Meas(ByVal lngCh As Long)
    Dim lcr_meas_cnt As Long
    
    '*** CH LCR ꊇ ***
    For lcr_meas_cnt = 0 To LCR_MeasNum(lngCh) - 1
        Call MeasLCR(lngCh, LCR_Meas(lngCh, lcr_meas_cnt))
    Next lcr_meas_cnt
 
End Sub

'****************
'   
'****************
Public Sub MeasExe(ByVal lngCh As Long, ByVal no As Long, ByRef msi As struct_measInfo, ByRef msdt As struct_measdata, ByRef msfmt As String, _
            ByRef inf_lcr() As struct_resonance, ByVal inf_num As Long, ByRef ch_meas_i() As struct_resonance_meas, ByRef ch_meas_num() As Long)

    On Error GoTo ErrMeas
    
    msdt.ResJudge = JUDG_FAIL
    
    Select Case UCase(msfmt)
        Case "LOGMAG":
                Call MeasLogmag(lngCh, no, msi, msdt, msfmt, inf_lcr, inf_num, ch_meas_i, ch_meas_num)
        Case "PHASE": msdt.ResData2 = ERR_VALUE
        Case "POLAR": msdt.ResData2 = ERR_VALUE
        Case "SMITH":
                Call MeasSmith(lngCh, no, msi, msdt, msfmt, inf_lcr, inf_num, ch_meas_i, ch_meas_num)
        Case "DELAY": msdt.ResData2 = ERR_VALUE
        Case "SWR":
                Call MeasSwr(lngCh, no, msi, msdt, msfmt)
        Case "REAL": msdt.ResData2 = ERR_VALUE
        Case "IMAG": msdt.ResData2 = ERR_VALUE
        Case Else: msdt.ResData2 = ERR_VALUE
    End Select

    On Error GoTo 0
    Exit Sub

ErrMeas:
    msdt.ResData2 = ERR_VALUE
    Resume Next

End Sub


'*****************************
'   ̔
'   return : PASS : JUDG_PASS
'            FAIL : JUDG_FAIL
'*****************************
Private Function MeasJudge(ByVal ch As Long, ByRef msi As struct_measInfo, ByRef msdt As struct_measdata) As Integer

    With msi
        If msdt.ResJudge <> JUDG___NO Then
            .passFlg = JUDG_PASS
            If .LwLmtFrqFlg Then If msdt.ResData1 < .LwLmtFrq Then .passFlg = JUDG_FAIL
            If .UpLmtFrqFlg Then If .UpLmtFrq < msdt.ResData1 Then .passFlg = JUDG_FAIL
            msdt.ResJudge1 = .passFlg
    
            If .UpLmtLvl = 0 And .LwLmtLvl = 0 Then
                .passFlg = JUDG_PASS
            Else
                .passFlg = JUDG_PASS
                If .UpLmtLvlFlg And .UpLmtLvl < msdt.ResData2 Then .passFlg = JUDG_FAIL 'l`FbN
                If .LwLmtLvlFlg And msdt.ResData2 < .LwLmtLvl Then .passFlg = JUDG_FAIL 'l`FbN
            End If
            msdt.ResJudge2 = .passFlg
    
            If .JudgeValid = BIS_OFF Then   '  = ̑荀
                .passFlg = JUDG_PASS
                msdt.ResJudge1 = JUDG_PASS
                msdt.ResJudge2 = JUDG_PASS
            End If
            
            If msdt.ResJudge1 = JUDG_FAIL Then msdt.ResFailCnt1 = msdt.ResFailCnt1 + 1  'Fail Count Up
            If msdt.ResJudge2 = JUDG_FAIL Then msdt.ResFailCnt2 = msdt.ResFailCnt2 + 1  'Fail Count Up
            
            If msdt.ResJudge1 = JUDG_FAIL Or msdt.ResJudge2 = JUDG_FAIL Then
                .passFlg = JUDG_FAIL
            End If
            
            msdt.ResJudge = .passFlg        ' 茋
        Else
            msdt.ResJudge1 = JUDG_PASS
            msdt.ResJudge2 = JUDG_PASS
            .passFlg = JUDG_PASS
        End If
        
        MeasJudge = .passFlg
     End With

End Function

'**********************
' g[XEf[^擾
'**********************
Private Sub get_TraceData(ch As Long, chinf As struct_Chinfo)
    Dim lngErr As Long
    Dim lngMsrP As Long
        
    With chinf
        lngMsrP = .lngTotP - 1
        If (.WaveFrmt And WAVE_FORMAT_LOGMAG) = WAVE_FORMAT_LOGMAG Then
            lngErr = QryTracData(lngPID, .TrLgm, 0, lngMsrP, BufLgm(0, ch))  'LOGŨf[^ǂݏo܂
        End If
        If (.WaveFrmt And WAVE_FORMAT____SWR) = WAVE_FORMAT____SWR Then
            lngErr = QryTracData(lngPID, .TrLnm, 0, lngMsrP, BufLnm(0, ch))  'LINMAG̃f[^ǂݏo܂
            Call get_Swr(ch, 0, lngMsrP)
        End If
        If (.WaveFrmt And WAVE_FORMAT__SMITH) = WAVE_FORMAT__SMITH Then
            lngErr = QryTracData(lngPID, .TrRel, 0, lngMsrP, BufReal(0, ch)) 'Real/Imag̃f[^ǂݏo܂
            lngErr = QryTracData(lngPID, .TrImg, 0, lngMsrP, BufImag(0, ch))
        End If
    End With

End Sub

'***************************
' Waveform display `FbN
'***************************
Private Sub Chk_TraceDraw_OnOff(ByVal ch As Long)

    If intFrmCh(ch) = 0 Then Exit Sub
    If frm_CH(ch).Check_TraceDraw.Value <> ChInfo(ch).intWaveDisp Then
        ChInfo(ch).intWaveDisp = frm_CH(ch).Check_TraceDraw.Value
        If ChInfo(ch).intWaveDisp = 0 Then
            frm_CH(ch).PictBox_Waveform.Cls     'g`\
            Call frm_CH(ch).ReDispResult        '荀ڍĕ\
        End If
    End If
End Sub

'*********************
' Cal ON/OFF `FbN
'*********************
Public Sub Chk_Cal_OnOff(ByVal ch As Long)
    Dim lngErr As Long
    
    If intFrmCh(ch) = 0 Then Exit Sub
    If frm_CH(ch).Check_cal.Value <> ChInfo(ch).Correct.CorOn Then
        If frm_CH(ch).Check_cal.Value = 1 Then
            lngErr = BisSensCorrCsetStat(lngPID, BIS_ON)
        Else
            lngErr = BisSensCorrCsetStat(lngPID, BIS_OFF)
        End If
        lngErr = QrySensCorrCsetStat(lngPID, ChInfo(ch).Correct.CorOn)
    End If
End Sub

'**********************
' Scale Enable Control
'**********************
Public Sub Scale_EnableCntrl(ByVal mx_ch As Long, ByVal bln As Boolean)
    Dim ch As Long
    
    For ch = ACT_CH1 To mx_ch
        If intFrmCh(lngACh) = 1 Then
            frm_CH(ch).Combo_WaveFormat.Enabled = bln
            frm_CH(ch).Text_scl(0).Enabled = bln
            frm_CH(ch).Text_scl(1).Enabled = bln
            frm_CH(ch).Text_scl(2).Enabled = bln
            frm_CH(ch).Combo_SwrRef.Enabled = bln
            frm_CH(ch).Combo_SwrDiv.Enabled = bln
        End If
    Next ch
End Sub

Public Sub Set_Trace_Scale(ByVal ch As Long)
    Dim i As Integer
    
    For i = 0 To ChInfo(ch).trcNum - 1
        With ChInfo(ch).trc(i)
            If frm_CH(ch).Combo_WaveFormat.ListIndex = McrIdxLgm Then
                .trcFmtScale.Mscl = ChInfo(ch).Trace.FmtScale.Mscl
            End If
            If frm_CH(ch).Combo_WaveFormat.ListIndex = McrIdxSwr Then
                .trcFmtScale.SWRscl = ChInfo(ch).Trace.FmtScale.SWRscl
            End If
        End With
    Next i
End Sub

'****************
' Auto Scale Set
'****************
Public Sub Set_Auto_Scale(ByVal ch As Long)
    Dim mx As Double
    Dim mn As Double
    Dim frq As Double
    Dim pt As Long
    Dim lngErr As Long
    Dim i As Integer
    
    If frm_CH(ch).Combo_WaveFormat.ListIndex = McrIdxLgm Then
        lngErr = QryFetcMax(lngPID, ChInfo(ch).TrLgm, 0, ChInfo(ch).lngTotP - 1, mx, frq, pt)
        lngErr = QryFetcMin(lngPID, ChInfo(ch).TrLgm, 0, ChInfo(ch).lngTotP - 1, mn, frq, pt)
        Call auto_scale(mx, mn, ChInfo(ch).Trace.FmtScale.Mscl)
        frm_CH(ch).Text_scl(0).Text = ChInfo(ch).Trace.FmtScale.Mscl.ref
        frm_CH(ch).Text_scl(1).Text = ChInfo(ch).Trace.FmtScale.Mscl.div
    ElseIf frm_CH(ch).Combo_WaveFormat.ListIndex = McrIdxSwr Then
        mx = CDbl(ChInfo(ch).Trace.MaxSwr)
        mn = CDbl(ChInfo(ch).Trace.MinSwr)
        Call auto_scale2(mx, mn, ChInfo(ch).Trace.FmtScale.SWRscl)
        i = get_unit_index(Math.Abs(ChInfo(ch).Trace.FmtScale.SWRscl.ref))
        frm_CH(ch).Text_scl(0).Text = chg_scale_unit(i, ChInfo(ch).Trace.FmtScale.SWRscl.ref)
        frm_CH(ch).Combo_SwrRef.ListIndex = i
        i = get_unit_index(ChInfo(ch).Trace.FmtScale.SWRscl.div)
        frm_CH(ch).Text_scl(1).Text = chg_scale_unit(i, ChInfo(ch).Trace.FmtScale.SWRscl.div)
        frm_CH(ch).Combo_SwrDiv.ListIndex = i
    End If
    
    Call Set_Trace_Scale(ch)
        
    If intFrmCh(ch) Then
        Call draw_graph(ch, frm_CH(ch).PictBox_Waveform)
        If DevCnt(ch).Total > 0 Then
            Call result_display(ch, frm_CH(ch).PictBox_Waveform)    ' *** 茋ʕ\ ***
        End If
    End If

    AutoScale(ch) = 0
End Sub

'*****************
' Device Count Up
'*****************
Private Sub DevCountUp(cnt As struct_DevCnt, intJudge As Integer)
    With cnt
        .Total = .Total + 1             '萔JEgAbv
        If intJudge = JUDG_PASS Then
           .Pass = .Pass + 1
        Else
           .Fail = .Fail + 1
        End If
    End With
End Sub

'********************
' Lot Button Control
'********************
Public Sub LotCntrlBtn(ch As Long, blnChkFDlg As Boolean, idx As Integer)
    Dim clr As struct_DevCnt
    Dim measct As Long

    If idx = IDX_LOT_START Then
        frm_CH(ch).CmdLotCtrl(IDX_LOT_START).Enabled = False
        frm_CH(ch).CmdLotCtrl(IDX_LOT_END).Enabled = True
        MDIfrmMain.Menu_Connect.Enabled = False
        For measct = 0 To ChInfo(ch).MeasSegNum - 1
            MeasData(ch, measct).ResFailCnt1 = 0
            MeasData(ch, measct).ResFailCnt2 = 0
        Next measct
        DevCnt(ch) = clr
        ChInfo(ch).intLotCntrl = LOT_START
        Call File_Kill(ch, HeaderFILE)
        Call File_Kill(ch, DataFILE)
        Call File_Kill(ch, WorkFILE)
        Call DevCountDisp(frm_CH(ch), DevCnt(ch))
    Else
        If DevCnt(ch).Total Then
            If MkResultDataFile(ch, blnChkFDlg, True) = True Then
                frm_CH(ch).CmdLotCtrl(IDX_LOT_START).Enabled = True
                frm_CH(ch).CmdLotCtrl(IDX_LOT_END).Enabled = False
                MDIfrmMain.Menu_Connect.Enabled = True
                ChInfo(ch).intLotCntrl = LOT_END
            End If
        Else
            frm_CH(ch).CmdLotCtrl(IDX_LOT_START).Enabled = True
            frm_CH(ch).CmdLotCtrl(IDX_LOT_END).Enabled = False
            MDIfrmMain.Menu_Connect.Enabled = True
            ChInfo(ch).intLotCntrl = LOT_END
        End If
    End If

End Sub

'*******************
' Device Count \
'*******************
Public Sub DevCountDisp(frm As frmCH, cnt As struct_DevCnt)
    With cnt
        frm.lblCounter(CNT_PASS).Caption = .Pass
        frm.lblCounter(CNT_FAIL).Caption = .Fail
        frm.lblCounter(CNT_TOTAL).Caption = .Total
        If .Total Then
            frm.lblPercent(CNT_PASS).Caption = Format$((.Pass / .Total) * 100, "##0.0") + "%"     ' PASS%
            frm.lblPercent(CNT_FAIL).Caption = Format$((.Fail / .Total) * 100, "##0.0") + "%"     ' Fail%
        Else
            frm.lblPercent(CNT_PASS).Caption = "0.0%"     ' PASS%
            frm.lblPercent(CNT_FAIL).Caption = "0.0%"     ' Fail%
        End If
    End With
End Sub


'*******************
' All CH Grid \
'*******************
Public Sub init_graph()
    Dim ch As Long
    
    For ch = 0 To ChNum - 1
        Call draw_graph(ch, frm_CH(ch).PictBox_Waveform)
    Next ch
End Sub

'************************
' | &  & g`\
'*************************
Public Sub bna_test()
    Dim lngErr As Long
    Dim blnjudg As Boolean
    Dim ch As Long
    Dim measct As Long
    Dim lngMsrP As Long
    Dim MeasFmt As String
    Dim jLCcnt As Integer
    Dim jflg As Integer
    Dim intJudge As Integer
    Dim strFailFn As String
    
    For ch = 0 To ChNum - 1                             '`l
'        If ChInfo(ch).intLotCntrl Then                  'bgEX^[gCH
            jLCcnt = 0
            jflg = JUDG_PASS
            lngErr = meas_ch(ch)                        'SW-BOX ؂ւ
            Call Chk_Cal_OnOff(ch)
            Call Chk_TraceDraw_OnOff(ch)
            lngErr = BisInitImm(lngPID)                 '|Jn
            lngErr = BisInitWai(lngPID)                 '|I҂
            '*** g`f[^擾 ***
            Call get_TraceData(ch, ChInfo(ch))
            '*** ӏ̑ ***
            If LCR_MeasNum(ch) > 0 Then Call Chk_LCR_Meas(ch)                       'LCR ꊇ
            For measct = 0 To ChInfo(ch).MeasSegNum - 1 '荀ڐ
                MeasFmt = ChInfo(ch).trc(MeasInfo(ch, measct).RefFmtNo - 1).strFormat
                Call MeasExe(ch, measct + 1, MeasInfo(ch, measct), MeasData(ch, measct), MeasFmt, LCR_Meas(), LCR_MeasNum(ch), LCR_MeasItem(), LCR_MeasItemNum())
                intJudge = MeasJudge(ch, MeasInfo(ch, measct), MeasData(ch, measct))
                If intJudge = JUDG_FAIL Then
                    jflg = JUDG_FAIL
                End If
                If MeasData(ch, measct).ResJudge = JUDG___NO And intJudge = JUDG_PASS Then
                    jLCcnt = jLCcnt + 1
                End If
            Next measct
            If measct = jLCcnt Then jflg = JUDG_FAIL
            If intFrmCh(ch) Then
                ' *** g`\ ****
                If ChInfo(ch).intWaveDisp Then
                    If AutoScale(lngACh) = 1 Then Call Set_Auto_Scale(ch)
                    Call draw_graph(ch, frm_CH(ch).PictBox_Waveform)
                Else
                    frm_CH(ch).PictBox_Waveform.Cls
                End If
                ' *** 茋ʕ\ ***
                Call result_display(ch, frm_CH(ch).PictBox_Waveform)
                ' ***  ****
                Call frm_CH(ch).JudgDisp(jflg)
                Call PreservationOfResult(ch, DevCnt(ch).Total, jflg)  'f[^ۑ
                Call DevCountUp(DevCnt(ch), jflg)                   'Count Up
                Call DevCountDisp(frm_CH(ch), DevCnt(ch))           'Count\
                If jflg = False And frm_CH(ch).Check_FailDataSave.Value Then
                    strFailFn = frm_CH(ch).Text_LotDataSvFileName.Text & "_" & Format(Now, "yyyymmdd_hhmm")
                    strFailFn = strSvMsrDtPathfileAtt & "\" & strFailFn & "_" & Format(DevCnt(ch).Total, "0000") & ".csv"
                    Call SaveTraceData(ch, strFailFn)
                End If
                frm_CH(ch).Refresh
            End If
'        End If
    Next ch
   
End Sub

'******************
' Ext Trigger ҂
'******************
Private Sub WaitExtTrg()
    Dim lngErr As Long
    Dim bg As Long
    Dim ed As Long
    Dim ep As Long
    Dim last1 As Long
    Dim bln As Boolean

    Do
        If ExitFlag = 1 Then Exit Sub
    
        last1 = ChInfo(lngACh).lngTotP
        lngErr = BisInitCont(lngPID, BIS_ON)                'A|
        lngErr = BisTrigSour(lngPID, EXTERNAL, lngPattern)  'Ext Trigger ҂
        lngErr = BisAbor(lngPID)                            '|~

        bg = 0: ed = 0
        Do                      'pI/F̓͐M܂ŁADoő҂܂B
            lngErr = QryStatSweCoun(lngPID, ep, ChInfo(lngACh).lngTotP)
            If ep < bg Then     ' t]ꍇS\
                bg = 0: ed = 0
                ep = last1
            End If
            If ed < ep Then
                ed = ep
            End If
            DoEvents
            If ExitFlag <> 0 Then
                lngErr = BisAbor(lngPID)                    '|~
                lngErr = BisTrigSour(lngPID, INTERNAL, 0)   'Internal Trigger
                Exit Sub
            End If
        Loop While (ed < last1)

        lngErr = BisAbor(lngPID)                            '|~
        lngErr = BisInitCont(lngPID, BIS_OFF)               'A| OFF
        lngErr = BisTrigSour(lngPID, INTERNAL, 0)           'Internal Trigger
        Call bna_test

        DoEvents
    Loop While (ContFlag)

End Sub

'Private Sub WaitExtTrg()
'    Dim lngErr As Long
'    Dim bg As Long
'    Dim ed As Long
'    Dim ep As Long
'    Dim last1 As Long
'
'    Do
'        last1 = lngTotP
'        If ExitFlag = 1 Then Exit Sub
'
'        lngErr = BisInitCont(lngPID, BIS_ON)                'A| ON
'        lngErr = BisTrigSour(lngPID, EXTERNAL, lngPattern)  'Ext Trigger ҂
'        lngErr = BisAbor(lngPID)                            '|~
'        bg = 0: ed = 0
'        Do
'            lngErr = QryStatSweCoun(NaPID(BdId), ep, totalP)
'            If ep < bg Then     ' Displays all data if reversed.
'                bg = 0: ed = 0
'                ep = last1
'            End If
'            If ed < ep Then
'                ed = ep
'                Call get_and_draw_wave(bg, ed - 1): bg = ed
'            End If
'            DoEvents
'            If ExitFlag <> 0 Then Exit Sub
'        Loop While (ed < last1)
'
'        Call bna_test
'        DoEvents
'    Loop While (ContFlag)
'End Sub

'*****************
' CE[v
'*****************
Private Sub Main()
    Dim lngErr As Long
    
    MDIfrmMain.Show
    Do      ''--------------------- Main Loop
        If ExitFlag = 1 Then        'TCP/IP Connect OFF?
            If lngPID Then
                lngErr = BisClosePacket(lngPID)
                lngPID = 0: ExitFlag = 0
            End If
        ElseIf ExitFlag = 2 Then    'frmMain [X]?
            If lngPID Then lngErr = BisClosePacket(lngPID)
            End
        End If
        If MDIfrmMain.ExtTriggerOn.Checked = True And ContFlag = 1 Then
            Call WaitExtTrg
        End If
        DoEvents
    Loop While (1)  ''------------- Main Loop
    
End Sub

